clear all

* Set Folder to output one

cd ..\Outputs

* Call database of merged unemployment and real GDP growth

use vin_all, clear

* Define the matrix of long-run restrictions

matrix lr = (.,0\.,.)

* Generate empty supply and demand decomposition to fill inside the loop

gen dlogY_BQ_supply=.
gen dlogY_BQ_demand=.

* Define growth of output and unemployment as the last available vintage

gen dlogY = GROUTPUT17Q1
gen UNR   = RUC17Q1

* Run the Blanchard and Quah structural VAR

svar dlogY UNR, lags(1/8) lreq(lr) 
matrix B=e(B)
matrix invB=inv(B)
capture drop resid*
predict residGY, resid equation(#1)
predict residUE, resid equation(#2)

* Obtain structural residuals

capture drop temp*
gen temp_supply=invB[1,1]*residGY+invB[1,2]*residUE
gen temp_demand=invB[2,1]*residGY+invB[2,2]*residUE

* Create IRF file for use inside the loop

irf create lr, set(lrirf, replace) step(100) replace

* Store IRF to supply shock

preserve
use lrirf.irf, clear
keep if response == "dlogY"
keep if impulse  == "dlogY"
keep step sirf
save temp1, replace
restore

* Store IRF to demand shock

preserve
use lrirf.irf, clear
keep if response == "dlogY"
keep if impulse  == "UNR"
keep step sirf
save temp2, replace
restore

* Loop over time periods to generate historical decomposition

sum t if e(sample)
local mint=r(min)
di "`mint'"
local maxt=r(max)
di "`maxt'"
local burn=0

quiet forvalues period=`=`mint'+`burn''(1)`maxt' {

	noisily di "`period'"
	capture drop step
	gen step=`period'-t
	
	* Calculate historical decomposition: supply side

	joinby step using temp1, unmatched(master)
	drop _merge

	capture drop temp_dlogY_BQ_supply
	gen temp_dlogY_BQ_supply=temp_supply*sirf 
	sum temp_dlogY_BQ_supply
	replace dlogY_BQ_supply=r(mean)*r(N) if t==`period'

	capture drop sirf

	* Calculate historical decomposition: demand side

	joinby step using temp2, unmatched(master)
	drop _merge

	capture drop temp_dlogY_BQ_demand
	gen temp_dlogY_BQ_demand=temp_demand*sirf 
	sum temp_dlogY_BQ_demand
	replace dlogY_BQ_demand=r(mean)*r(N) if t==`period'

	capture drop sirf
	
}

sum dlogY
gen demeaned_dlogY=dlogY-r(mean)
gen dlogY_BQ_total=dlogY_BQ_supply+dlogY_BQ_demand
  
rename temp_supply  dlogY_BQfs_supply_shock
rename temp_demand  dlogY_BQfs_demand_shock

keep year quarter dlogY_BQ* dlogY
rename dlogY_BQ_supply dlogY_BQfs_supply
rename dlogY_BQ_demand dlogY_BQfs_demand
rename dlogY_BQ_total  dlogY_BQfs_total
rename dlogY           dlogYfs
drop if year<1950

save BQfullsample, replace
erase temp1.dta
erase temp2.dta
